#include <iostream>
#include <algorithm>

using namespace std;

struct Pomeraj{
    int x;
    int y;
    int i;
};

long long vek_pr(Pomeraj a, Pomeraj b) {
    return 1ll * a.x * b.y - 1ll * b.x * a.y;
}

long long skal_pr(Pomeraj a, Pomeraj b) {
    return 1ll * a.x * b.x + 1ll * a.y * b.y;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    cin >> n;
    
    Pomeraj pomeraji[n];
    for(int i = 0, nula = 0; i < n; i++) {
        cin >> pomeraji[i].x >> pomeraji[i].y;
        pomeraji[i].i = i + nula;
        if(pomeraji[i].x == 0 && pomeraji[i].y == 0) {
            i--;
            n--;
            nula++;
        }
    }
    
    sort(pomeraji, pomeraji + n, [](const Pomeraj &a, const Pomeraj &b) {
        bool A = a.y > 0 || (a.y == 0 && a.x >= 0);
        bool B = b.y > 0 || (b.y == 0 && b.x >= 0);
        if(A != B) return A;
        return vek_pr(a, b) > 0;
    });
    
    int pocetak = 0, kraj = 0, maks_pocetak = 0, maks_kraj = 0;
    long long X = 0, Y = 0;
    unsigned long long maks_udaljenost = 0;
    while(pocetak < n) {
        while((vek_pr(pomeraji[pocetak], pomeraji[kraj%n]) > 0 ||
               (vek_pr(pomeraji[pocetak], pomeraji[kraj%n]) == 0 &&
                skal_pr(pomeraji[pocetak], pomeraji[kraj%n]) > 0))
              && kraj - pocetak < n) {
            X += pomeraji[kraj%n].x;
            Y += pomeraji[kraj%n].y;
            kraj++;
            if(maks_udaljenost < 1ull * X * X + 1ull * Y * Y) {
                maks_udaljenost = 1ull * X * X + 1ull * Y * Y;
                maks_pocetak = pocetak;
                maks_kraj = kraj;
            }
        }
        X -= pomeraji[pocetak].x;
        Y -= pomeraji[pocetak].y;
        pocetak++;
        if(maks_udaljenost < 1ull * X * X + 1ull * Y * Y) {
            maks_udaljenost = 1ull * X * X + 1ull * Y * Y;
            maks_pocetak = pocetak;
            maks_kraj = kraj;
        }
    }
    
    int broj_pomeraja = maks_kraj - maks_pocetak;
    cout << broj_pomeraja << endl;
    for(int i = 0; i < broj_pomeraja; i++)
        cout << pomeraji[(maks_pocetak + i) % n].i + 1 << ' ';
    
    return 0;
}